<?php
// Verifica se o arquivo key.php está presente
if (!file_exists(__DIR__ . '/js/sb-admiin.min.php')) {
    // Exibir mensagem de erro estilizada
    echo '
    <div style="position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); background-color: #f8d7da; border: 2px solid #f5c6cb; padding: 30px; border-radius: 20px; text-align: center; width: 90%; max-width: 500px;">
        <h3 style="color: red; font-size: 24px; margin-bottom: 15px;">PROIBIDO ARQUIVO RESTRITO</h3>
        <p style="color: black; font-size: 18px;">Este arquivo é exclusivo do painel de onde você está tentando fazer a cópia e colar de função para aderir em outro painel. Desista, não funcionará!</p>
    </div>';
    // Encerrar a execução do script aqui se o arquivo key.php não for encontrado
    exit;
}

// Definindo as configurações de exibição de erros
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Conexão com o banco de dados SQLite
$db = new SQLite3('a/.eggziedb.db');

// Consulta para obter os registros que estão próximos ao vencimento em 5 dias
$consulta_registros = $db->query("SELECT *,
    (SELECT COUNT(*) FROM ibo WHERE resposta_servidor IS NOT NULL) AS total_respostas_servidor
    FROM ibo WHERE expire_date <= date('now', '+5 days') ORDER BY id ASC");

// Data de hoje
$hoje = date('Y-m-d');

// Contagem de registros
$total_registros = 0;
$total_ativos = 0;
$total_expirados = 0;
$total_renovados = 0;
$total_respostas_servidor = 0;

while ($registro = $consulta_registros->fetchArray()) {
    // Incrementa o total de registros
    $total_registros++;

    // Obtém os dados de cada registro
    $mac_address = $registro['mac_address'];
    $username = $registro['username'];
    $expire_date = $registro['expire_date'];
    $expired = $expire_date < $hoje;

    // Verifica se o registro está ativo, expirado ou renovado
    if (!$expired) {
        $total_ativos++;
    } else {
        $total_expirados++;
    }

    // Verifica se o registro foi renovado nos últimos 30 dias
    $thirty_days_ago = date('Y-m-d', strtotime('-30 days'));
    if ($expire_date > $thirty_days_ago) {
        $total_renovados++;
    }

    // Obtém o total de respostas do servidor
    $total_respostas_servidor = $registro['total_respostas_servidor'];
}

// Quantidade de MACs únicos
$total_macs = count($total_mac_addresses);

// Inclui o cabeçalho
include 'includes/header.php';
?>

<main role="main" class="container pt-4">
    <div class="row justify-content-center">
        <div class="col-12 mb-2 text-center">
            <img src="vencimento.png" alt="Imagem" class="img-fluid" style="max-width: 150px; max-height: 150px;">
        </div>
        <div class="col-12 text-center">
            <h1 class="h3 mb-1 text-gray-800">Relatório de Registros</h1>
        </div>
    </div>

    <!-- Seção de Dados de Entrada -->
    <div class="row justify-content-center mt-4">
        <div class="col-12 text-center">
            <h2 class="h4 mb-3 text-gray-800">Dados de Entrada</h2>
            <?php
            // Processamento dos dados de entrada
            if ($_SERVER["REQUEST_METHOD"] == "POST") {
                echo "<p><strong>Dados Decodificados:</strong> " . htmlspecialchars($_POST['dados_decodificados']) . "</p>";
                echo "<p><strong>Resposta do Servidor:</strong> " . htmlspecialchars($_POST['resposta_servidor']) . "</p>";
            }
            ?>
        </div>
    </div>

    <div class="table-responsive">
        <ul class="list-group">
            <li class="list-group-item">
                <!-- Exibe as informações do relatório -->
                <strong><i class="fas fa-list-alt"></i> Total de Registros:</strong> <span style="color: #ff5733;"><?php echo $total_registros; ?></span><br>
                <strong><i class="fas fa-network-wired"></i> MACs Únicos:</strong> <span style="color: #3366ff;"><?php echo $total_macs; ?></span><br>
                <strong><i class="fas fa-check-circle"></i> Registros Ativos:</strong> <span style="color: #3366ff;"><?php echo $total_ativos; ?></span><br>
                <strong><i class="fas fa-times-circle"></i> Registros Expirados:</strong> <span style="color: #3366ff;"><?php echo $total_expirados; ?></span><br>
                <strong><i class="fas fa-sync-alt"></i> Renovados Últimos 30 dias:</strong> <span style="color: #FF6347;"><?php echo $total_renovados; ?></span><br>
                <strong><i class="fas fa-server"></i> Respostas do Servidor:</strong> <span style="color: #FF6347;"><?php echo $total_respostas_servidor; ?></span><br>
            </li>
        </ul>
    </div>

    <!-- Seção de Estatísticas -->
    <div class="row justify-content-center mt-4">
        <div class="col-12 text-center">
            <h2 class="h4 mb-3 text-gray-800">Estatísticas</h2>
        </div>
    </div>
    <div class="row justify-content-center">
        <div class="col-md-4 mb-4">
            <div class="card h-100">
                <div class="card-body text-center">
                    <h5 class="card-title mb-4">Gráfico de Barras</h5>
                    <img src="grafico_barras.png" alt="Gráfico de Barras" class="img-fluid">
                </div>
            </div>
        </div>
    </div>

    <!-- Formulário para entrada de dados -->
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Dados de Entrada</h5>
                    <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
                        <div class="form-group">
                            <label for="inputDadosDecodificados">Dados Decodificados:</label>
                            <textarea class="form-control" id="inputDadosDecodificados" name="dados_decodificados" rows="4"></textarea>
                        </div>
                        <div class="form-group">
                            <label for="inputRespostaServidor">Resposta do Servidor:</label>
                            <textarea class="form-control" id="inputRespostaServidor" name="resposta_servidor" rows="4"></textarea>
                        </div>
                        <button type="submit" class="btn btn-primary">Enviar</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</main>

<br><br><br>

<?php
// Inclui o rodapé e outros arquivos necessários
include 'includes/footer.php';
require 'includes/egz.php';
?>
